#ifndef __SMIplImage_h__
#define __SMIplImage_h__

#include "cxcore.h"
#include <boost/interprocess/allocators/allocator.hpp>
#include <boost/interprocess/managed_shared_memory.hpp>
#include <boost/interprocess/offset_ptr.hpp>

typedef boost::interprocess::managed_shared_memory::segment_manager                       
	TSegmentManager;
typedef boost::interprocess::allocator< void, TSegmentManager>                          
	TVoidAllocator;
typedef boost::interprocess::allocator< char, TSegmentManager>                          
	TCharAllocator;


class TSMImage{

	long long timestamp;
	int userCount;
	int width, height;
	int depth;
	int nChannels;
	TCharAllocator alloc;
	int byteDepth;

	boost::interprocess::offset_ptr< char> imageData;

public:

	TSMImage( const CvSize size, const int depth, const int nChannels, TVoidAllocator void_alloc);
	~TSMImage();
	IplImage * createIplImage();

	int use();
	int ret();
	int getUserCount();

	long long getTS();
	void setTS( long long);


};


#endif
